//************************************************************************************
//**  
//**  File name:     C:\Documents and Settings\Perso\Bureau\Examples\Exemple +\Components\ADC\4. Voltage as Float.c
//**  Generated by:  Flowcode v4.0.0.53
//**  Date:          Monday, January 25, 2010 23:49:46
//**  Licence:       
//**  Registered to: Perso
//**  
//**  
//**     NOT FOR COMMERCIAL USE
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_PIC

//Defines for microcontroller
#define P16F877A
#define MX_EE
#define MX_EE_TYPE2
#define MX_EE_SIZE 256
#define MX_SPI
#define MX_SPI_C
#define MX_SPI_SDI 4
#define MX_SPI_SDO 5
#define MX_SPI_SCK 3
#define MX_UART
#define MX_UART_C
#define MX_UART_TX 6
#define MX_UART_RX 7
#define MX_I2C
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 4
#define MX_I2C_SCL 3
#define MX_PWM
#define MX_PWM_CNT 2
#define MX_PWM_TRIS1 trisc
#define MX_PWM_1 2
#define MX_PWM_TRIS2 trisc
#define MX_PWM_2 1

//Functions
#include <system.h>
#pragma CLOCK_FREQ 19660800

//Configuration data

//Internal functions
#include "C:\Program Files\Matrix Multimedia\Flowcode V4\FCD\internals.h"

//Macro function declarations
void FCM_INTERRUPT_TMR0();
void FCM_INTERRUPT_RB0INT();
void FCM_INTERRUPT_PORTB();


//Variable declarations
#define FCSZ_STRING 20
#define FCSZ_STRING2 20
char FCV_STRING[FCSZ_STRING];
char FCV_STRING2[FCSZ_STRING2];
float FCV_FLOAT;


//Defines:

/**** Macro Substitutions ****
portb = D1 Port
trisb = D1 Data Direction
portb = D2 Port
trisb = D2 Data Direction
portb = D3 Port
trisb = D3 Data Direction
portb = D4 Port
trisb = D4 Data Direction
portb = RS Port
trisb = RS Data Direction
portb = E Port
trisb = E Data Direction
0 = Data 1_Pin
1 = Data 2 Pin
2 = Data 3 Pin
3 = Data 4 Pin
4 = RS Pin
5 = Enable Pin
LCD_3016686 = Unique Component Reference Number
2 = Row Count
16 = Column Count
******************************/

	//component connections
	#define LCD_3016686_PORT0    portb
	#define LCD_3016686_TRIS0    trisb
	#define LCD_3016686_PORT1    portb
	#define LCD_3016686_TRIS1    trisb
	#define LCD_3016686_PORT2    portb
	#define LCD_3016686_TRIS2    trisb
	#define LCD_3016686_PORT3    portb
	#define LCD_3016686_TRIS3    trisb
	#define LCD_3016686_PORT4    portb
	#define LCD_3016686_TRIS4    trisb
	#define LCD_3016686_PORT5    portb
	#define LCD_3016686_TRIS5    trisb
	#define LCD_3016686_BIT0    	0
	#define LCD_3016686_BIT1    	1
	#define LCD_3016686_BIT2    	2
	#define LCD_3016686_BIT3    	3
	#define LCD_3016686_RS      	4
	#define LCD_3016686_E       	5
	#define LCD_3016686_ROWCNT	2
	#define LCD_3016686_COLCNT	16

	#ifdef _BOOSTC
	  #define LCD_3016686_DELAY   delay_10us(10)
	#endif
	#ifdef _C2C_
	  #define LCD_3016686_DELAY   delay_us(100)
	#endif
	#ifndef LCD_3016686_DELAY
	  #define LCD_3016686_DELAY   delay_us(100)
	#endif




//LCDDisplay0: //Macro function declarations

void FCD_LCDDisplay0_RawSend(char in, char mask);
void FCD_LCDDisplay0_Start();
void FCD_LCDDisplay0_Clear();
void FCD_LCDDisplay0_PrintASCII(char Character);
void FCD_LCDDisplay0_Command(char in);
void FCD_LCDDisplay0_Cursor(char x, char y);
void FCD_LCDDisplay0_PrintNumber(short Number);
void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String);
void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions);
void FCD_LCDDisplay0_ClearLine(char Line);
void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7);
//Defines:

/**** Macro Substitutions ****
0 = Which ADC Channel
40 = Acquisition time
3 = Conversion Speed
0 = VRef+ Option
500 = VRef Voltage x 0.01V
******************************/




//ADC0: //Macro function declarations

void FCD_ADC0_SampleADC();
char FCD_ADC0_ReadAsByte();
short FCD_ADC0_ReadAsInt();
float FCD_ADC0_ReadAsVoltage();
void FCD_ADC0_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE, char NumBytes);



//LCDDisplay0: //Macro implementations


void FCD_LCDDisplay0_RawSend(char in, char mask)
{
		unsigned char pt;

		clear_bit(LCD_3016686_PORT0, LCD_3016686_BIT0);
		clear_bit(LCD_3016686_PORT1, LCD_3016686_BIT1);
		clear_bit(LCD_3016686_PORT2, LCD_3016686_BIT2);
		clear_bit(LCD_3016686_PORT3, LCD_3016686_BIT3);
		clear_bit(LCD_3016686_PORT4, LCD_3016686_RS);
		clear_bit(LCD_3016686_PORT5, LCD_3016686_E);
		pt = ((in >> 4) & 0x0f);
		if (pt & 0x01)
		    set_bit(LCD_3016686_PORT0, LCD_3016686_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_3016686_PORT1, LCD_3016686_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_3016686_PORT2, LCD_3016686_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_3016686_PORT3, LCD_3016686_BIT3);
		if (mask)
		    set_bit(LCD_3016686_PORT4, LCD_3016686_RS);
		LCD_3016686_DELAY;
		set_bit (LCD_3016686_PORT5, LCD_3016686_E);
		LCD_3016686_DELAY;
		clear_bit (LCD_3016686_PORT5, LCD_3016686_E);
		pt = (in & 0x0f);
		LCD_3016686_DELAY;
		clear_bit(LCD_3016686_PORT0, LCD_3016686_BIT0);
		clear_bit(LCD_3016686_PORT1, LCD_3016686_BIT1);
		clear_bit(LCD_3016686_PORT2, LCD_3016686_BIT2);
		clear_bit(LCD_3016686_PORT3, LCD_3016686_BIT3);
		clear_bit(LCD_3016686_PORT4, LCD_3016686_RS);
		clear_bit(LCD_3016686_PORT5, LCD_3016686_E);
		if (pt & 0x01)
		    set_bit(LCD_3016686_PORT0, LCD_3016686_BIT0);
		if (pt & 0x02)
		    set_bit(LCD_3016686_PORT1, LCD_3016686_BIT1);
		if (pt & 0x04)
		    set_bit(LCD_3016686_PORT2, LCD_3016686_BIT2);
		if (pt & 0x08)
		    set_bit(LCD_3016686_PORT3, LCD_3016686_BIT3);
		if (mask)
		    set_bit(LCD_3016686_PORT4, LCD_3016686_RS);
		LCD_3016686_DELAY;
		set_bit (LCD_3016686_PORT5, LCD_3016686_E);
		LCD_3016686_DELAY;
		clear_bit (LCD_3016686_PORT5, LCD_3016686_E);
		LCD_3016686_DELAY;
}

void FCD_LCDDisplay0_Start()
{
	
		clear_bit(LCD_3016686_TRIS0, LCD_3016686_BIT0);
		clear_bit(LCD_3016686_TRIS1, LCD_3016686_BIT1);
		clear_bit(LCD_3016686_TRIS2, LCD_3016686_BIT2);
		clear_bit(LCD_3016686_TRIS3, LCD_3016686_BIT3);
		clear_bit(LCD_3016686_TRIS4, LCD_3016686_RS);
		clear_bit(LCD_3016686_TRIS5, LCD_3016686_E);

		Wdt_Delay_Ms(12);

		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x33, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x32, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x2c, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x06, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x0c, 0);
		Wdt_Delay_Ms(2);

		//clear the display
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Clear()
{
	
		FCD_LCDDisplay0_RawSend(0x01, 0);
		Wdt_Delay_Ms(2);
		FCD_LCDDisplay0_RawSend(0x02, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintASCII(char Character)
{
	
		FCD_LCDDisplay0_RawSend(Character, 0x10);

}

void FCD_LCDDisplay0_Command(char in)
{
	
		FCD_LCDDisplay0_RawSend(in, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_Cursor(char x, char y)
{
	
	  #if (LCD_3016686_ROWCNT == 1)
	    y=0x80;
	  #endif

	  #if (LCD_3016686_ROWCNT == 2)
		if (y==0)
			y=0x80;
		else
			y=0xc0;
	  #endif

	  #if (LCD_3016686_ROWCNT == 4)
		if (y==0)
			y=0x80;
		else if (y==1)
			y=0xc0;

		#if (LCD_3016686_COLCNT == 16)
			else if (y==2)
				y=0x90;
			else
				y=0xd0;
		#endif

		#if (LCD_3016686_COLCNT == 20)
			else if (y==2)
				y=0x94;
			else
				y=0xd4;
		#endif
	  #endif

		FCD_LCDDisplay0_RawSend(y+x, 0);
		Wdt_Delay_Ms(2);

}

void FCD_LCDDisplay0_PrintNumber(short Number)
{
	
		short tmp_int;
		char tmp_byte;
		if (Number < 0)
		{
			FCD_LCDDisplay0_RawSend('-', 0x10);
			Number = 0 - Number;
		}

		tmp_int = Number;
		if (Number >= 10000)
		{
			tmp_byte = tmp_int / 10000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10000;
				tmp_byte--;
			}
		}
		if (Number >= 1000)
		{
			tmp_byte = tmp_int / 1000;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 1000;
				tmp_byte--;
			}
		}
		if (Number >= 100)
		{
			tmp_byte = tmp_int / 100;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 100;
				tmp_byte--;
			}
		}
		if (Number >= 10)
		{
			tmp_byte = tmp_int / 10;
			FCD_LCDDisplay0_RawSend('0' + tmp_byte, 0x10);

			while (tmp_byte > 0)
			{
				tmp_int = tmp_int - 10;
				tmp_byte--;
			}
		}
		FCD_LCDDisplay0_RawSend('0' + tmp_int, 0x10);

}

void FCD_LCDDisplay0_PrintString(char* String, char MSZ_String)
{
	
		char idx;
		for (idx=0; idx<MSZ_String; idx++)
		{
			if (String[idx]==0)
			{
				break;
			}
			FCD_LCDDisplay0_RawSend(String[idx], 0x10);
		}

}

void FCD_LCDDisplay0_ScrollDisplay(char Direction, char Num_Positions)
{
	
		char cmd = 0;
		char count;

		//Choose the direction
		switch (Direction)
		{
			case 0:
			case 'l':
			case 'L':

				cmd = 0x18;
				break;

			case 1:
			case 'r':
			case 'R':

				cmd = 0x1C;
				break;

			default:
				break;
		}

		//If direction accepted then scroll the specified amount
		if (cmd)
		{
			for (count = 0; count < Num_Positions; count++)
				FCD_LCDDisplay0_Command(cmd);
		}

}

void FCD_LCDDisplay0_ClearLine(char Line)
{
	
		char count;
		char rowcount;

		//Define number of columns per line
		#if (LCD_3016686_ROWCNT == 1)
			rowcount=80;
		#endif

		#if (LCD_3016686_ROWCNT == 2)
			rowcount=40;
		#endif

		#if (LCD_3016686_ROWCNT == 4)
			#if (LCD_3016686_COLCNT == 16)
				rowcount=16;
			#endif
			#if (LCD_3016686_COLCNT == 20)
				rowcount=20;
			#endif
		#endif

		//Start at beginning of the line
		FCD_LCDDisplay0_Cursor (0, Line);

		//Send out spaces to clear line
		for (count = 0; count < rowcount; count++)
			FCD_LCDDisplay0_RawSend(' ', 0x10);

		//Move back to the beginning of the line.
		FCD_LCDDisplay0_Cursor (0, Line);

}

void FCD_LCDDisplay0_RAM_Write(char nIdx, char d0, char d1, char d2, char d3, char d4, char d5, char d6, char d7)
{
	   //set CGRAM address
	   FCD_LCDDisplay0_RawSend(64 + (nIdx << 3), 0);
	   delay_ms(2);

	   //write CGRAM data
	   FCD_LCDDisplay0_RawSend(d0, 0x10);
	   FCD_LCDDisplay0_RawSend(d1, 0x10);
	   FCD_LCDDisplay0_RawSend(d2, 0x10);
	   FCD_LCDDisplay0_RawSend(d3, 0x10);
	   FCD_LCDDisplay0_RawSend(d4, 0x10);
	   FCD_LCDDisplay0_RawSend(d5, 0x10);
	   FCD_LCDDisplay0_RawSend(d6, 0x10);
	   FCD_LCDDisplay0_RawSend(d7, 0x10);

	   //Clear the display
	   FCD_LCDDisplay0_RawSend(0x01, 0);
	   delay_ms(2);
	   FCD_LCDDisplay0_RawSend(0x02, 0);
	   delay_ms(2);
}



//ADC0: //Macro implementations


void FCD_ADC0_SampleADC()
{
	
	/*******Supported Devices******************************************************************
	// 16C72, 16C72A, 16CR72, 16F72, 16C73, 16C73A, 16C73B, 16F73, 16C74, 16C74A, 16C74B, 16F74,
	// 16C76, 16F76, 16C77, 16F77, 16F818, 16F819, 16F870, 16F871, 16F872, 16F873, 16F873A,
	// 16F874, 16F874A, 16F876, 16F876A, 16F877, 16F877A,
	******************************************************************************************/

		#define MX_ADC_CHANNEL		0
		#define MX_ADC_SAMP_TIME 	40
		#define MX_ADC_CONV_SP		3
		#define MX_ADC_VREF_OPT		0

		//set up ADC conversion
		char old_tris, cnt;

		//find appropriate bit
		#if (MX_ADC_CHANNEL == 0)
			#define MX_ADC_TRIS_MSK  0x01
			#define MX_ADC_TRIS_REG  trisa
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x0E;
			#else
				adcon1 = 0x05;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 1)
			#define MX_ADC_TRIS_MSK  0x02
			#define MX_ADC_TRIS_REG  trisa
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x04;
			#else
				adcon1 = 0x05;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 2)
			#define MX_ADC_TRIS_MSK  0x04
			#define MX_ADC_TRIS_REG  trisa
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x02;
			#else
				adcon1 = 0x03;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 3)
			#define MX_ADC_TRIS_MSK  0x08
			#define MX_ADC_TRIS_REG  trisa
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x04;
			#else
				#pragma error "Target device is currently using AN3 for VREF+"
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 4)
			#define MX_ADC_TRIS_MSK  0x20
			#define MX_ADC_TRIS_REG  trisa
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x02;
			#else
				adcon1 = 0x03;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 5)
			#define MX_ADC_TRIS_MSK  0x01
			#define MX_ADC_TRIS_REG  trise
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x09;
			#else
				adcon1 = 0x01;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 6)
			#define MX_ADC_TRIS_MSK  0x02
			#define MX_ADC_TRIS_REG  trise
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x00;
			#else
				adcon1 = 0x01;
			#endif
		#endif
		#if (MX_ADC_CHANNEL == 7)
			#define MX_ADC_TRIS_MSK  0x04
			#define MX_ADC_TRIS_REG  trise
			#if (MX_ADC_VREF_OPT == 0)
				adcon1 = 0x00;
			#else
				adcon1 = 0x01;
			#endif
		#endif

		//sanity check
		#ifndef MX_ADC_TRIS_REG
			#pragma error "ADC Type 1 conversion code error - please contact technical support"
		#endif

		//assign conversion speed
		#if (MX_ADC_CONV_SP > 3)
			set_bit(adcon1, ADCS2);
		#endif

		//store old tris value, and set the i/o pin as an input
		old_tris = MX_ADC_TRIS_REG;
		MX_ADC_TRIS_REG = MX_ADC_TRIS_REG | MX_ADC_TRIS_MSK;

		//turn ADC on
		adcon0 = (0x01 | (MX_ADC_CONV_SP << 6)) | (MX_ADC_CHANNEL << 3);

		//wait the acquisition time
		cnt = 0;
		while (cnt < MX_ADC_SAMP_TIME) cnt++;

		//begin conversion and wait until it has finished
		adcon0 = adcon0 | 0x04;
		while (adcon0 & 0x04);

		//restore old tris value, and reset adc registers
		MX_ADC_TRIS_REG = old_tris;
		adcon1 = 0x07;
		adcon0 = 0x00;

		#undef MX_ADC_CHANNEL
		#undef MX_ADC_TRIS_REG
		#undef MX_ADC_TRIS_MSK
		#undef MX_ADC_SAMP_TIME
		#undef MX_ADC_CONV_SP
		#undef MX_ADC_VREF_OPT

}

char FCD_ADC0_ReadAsByte()
{
	
		FCD_ADC0_SampleADC();

		return adresh;

}

short FCD_ADC0_ReadAsInt()
{
	
		short iRetVal;

		FCD_ADC0_SampleADC();

		iRetVal = (adresh << 2);
		iRetVal = iRetVal | (adresl >> 6);

		return (iRetVal);

}

float FCD_ADC0_ReadAsVoltage()
{
	

		int iSample;
		float fSample, fVoltage, fVperDiv;

		#define MX_ADC_VREF_V		500

		iSample = FCD_ADC0_ReadAsInt();											//Read as 10-bit Integer

		fVoltage = float32_from_int32(MX_ADC_VREF_V);					//Convert reference voltage count to floating point (0 - 500 x 10mV)
		fVoltage = float32_mul(fVoltage, 0.01);							//Convert reference voltage count to actual voltage (0 - 5)
		fVperDiv = float32_mul(fVoltage, 0.000976);						//Convert actual voltage to voltage per division (VRef / 1024)
		fSample = float32_from_int32(iSample);							//Convert to floating point variable
		fVoltage = float32_mul(fSample, fVperDiv);						//Calculate floating point voltage

		#undef MX_ADC_VREF_V
		return (fVoltage);

}

void FCD_ADC0_ReadAsString(char* FCR_RETVAL, char FCR_RETVAL_SIZE, char NumBytes)
{
	
		float fVoltage;

		if (NumBytes > FCR_RETVAL_SIZE)
			NumBytes = FCR_RETVAL_SIZE;

		fVoltage = FCD_ADC0_ReadAsVoltage();
		FCI_FLOAT_TO_STRING(fVoltage, 2, FCR_RETVAL, NumBytes);	//Convert to String

}

//Macro implementations

void FCM_INTERRUPT_TMR0()
{
	
}

void FCM_INTERRUPT_RB0INT()
{
	
}

void FCM_INTERRUPT_PORTB()
{
	
}

void main()
{
	//Using Analogue inputs
	
	//Initialisation
	adcon1 = 0x07;


	//Interrupt initialisation code
	option_reg = 0xC0;


	//Initialise the LCD display
	//Call Component Macro: LCDDisplay(0)::Start
	FCD_LCDDisplay0_Start();


	//Loop
	//Loop: While 1
	while (1)
	{
		//Sample and store the 10-bit result
		//Call Component Macro: float=ADC(0)::ReadAsVoltage
		FCV_FLOAT = FCD_ADC0_ReadAsVoltage();


		//Convert float to string
		//String Manipulation:
		//  string = FloatToString$(float)
		//  string = left$(string, 4)
		//  string = string + " V"
		//  string2 = "Tension : "
		FCI_FLOAT_TO_STRING(FCV_FLOAT,6,FCV_STRING,FCSZ_STRING);
		FCI_LEFTSTRING(FCV_STRING,FCSZ_STRING,FCV_STRING,FCSZ_STRING,4);
		FCI_CONCATENATE(FCV_STRING,FCSZ_STRING," V",2,FCV_STRING,FCSZ_STRING);
		FCI_CONCATENATE("Tension : ",10,"",0,FCV_STRING2,FCSZ_STRING2);
		

		//Cler the display
		//Call Component Macro: LCDDisplay(0)::Clear
		FCD_LCDDisplay0_Clear();


		//Call Component Macro
		//Call Component Macro: LCDDisplay(0)::PrintString(string2)
		FCD_LCDDisplay0_PrintString(FCV_STRING2,FCSZ_STRING2);


		//Call Component Macro
		//Call Component Macro: LCDDisplay(0)::Cursor(0, 2)
		FCD_LCDDisplay0_Cursor(0, 2);


		//Display the value
		//Call Component Macro: LCDDisplay(0)::PrintString(string)
		FCD_LCDDisplay0_PrintString(FCV_STRING,FCSZ_STRING);


		//Delay
		//Delay: 200 ms
		delay_ms(200);


	}


	mainendloop: goto mainendloop;
}

void interrupt(void)
{
}



